unit UPizza;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, ZedGraph, System.Globalization;

type
  TFrmPizza = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TFrmPizza_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    ZedGraphControl1: ZedGraph.ZedGraphControl;
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFrmPizza))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmPizza.InitializeComponent;
begin
  Self.ZedGraphControl1 := ZedGraph.ZedGraphControl.Create;
  Self.SuspendLayout;
  // 
  // ZedGraphControl1
  // 
  Self.ZedGraphControl1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ZedGraphControl1.CultureInfo := System.Globalization.CultureInfo.Create('p' +
    't-BR');
  Self.ZedGraphControl1.IsAutoScrollRange := False;
  Self.ZedGraphControl1.IsEnableHPan := True;
  Self.ZedGraphControl1.IsEnableVPan := True;
  Self.ZedGraphControl1.IsEnableZoom := True;
  Self.ZedGraphControl1.IsScrollY2 := False;
  Self.ZedGraphControl1.IsShowContextMenu := True;
  Self.ZedGraphControl1.IsShowHScrollBar := False;
  Self.ZedGraphControl1.IsShowPointValues := False;
  Self.ZedGraphControl1.IsShowVScrollBar := False;
  Self.ZedGraphControl1.IsZoomOnMouseCenter := False;
  Self.ZedGraphControl1.Location := System.Drawing.Point.Create(8, 8);
  Self.ZedGraphControl1.Name := 'ZedGraphControl1';
  Self.ZedGraphControl1.PanButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.PanButtons2 := System.Windows.Forms.MouseButtons.Middle;
  Self.ZedGraphControl1.PanModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.PointDateFormat := 'g';
  Self.ZedGraphControl1.PointValueFormat := 'G';
  Self.ZedGraphControl1.ScrollMaxX := 0;
  Self.ZedGraphControl1.ScrollMaxY := 0;
  Self.ZedGraphControl1.ScrollMaxY2 := 0;
  Self.ZedGraphControl1.ScrollMinX := 0;
  Self.ZedGraphControl1.ScrollMinY := 0;
  Self.ZedGraphControl1.ScrollMinY2 := 0;
  Self.ZedGraphControl1.Size := System.Drawing.Size.Create(616, 328);
  Self.ZedGraphControl1.TabIndex := 0;
  Self.ZedGraphControl1.ZoomButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.ZoomButtons2 := System.Windows.Forms.MouseButtons.None;
  Self.ZedGraphControl1.ZoomModifierKeys := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomStepFraction := 0.100000001490116;
  // 
  // TFrmPizza
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(632, 342);
  Self.Controls.Add(Self.ZedGraphControl1);
  Self.Name := 'TFrmPizza';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'WinForm';
  Self.WindowState := System.Windows.Forms.FormWindowState.Maximized;
  Include(Self.Load, Self.TFrmPizza_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFrmPizza.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFrmPizza.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TFrmPizza.TFrmPizza_Load(sender: System.Object; e: System.EventArgs);
var
  Fatia: PieItem;
  Fatias: array of PieItem;

{
  Fatia  uma varivel do tipo PieItem que representa uma fatia de um
  grfico de pizza.

  Fatias  um vetor de PieItem (fatia) dinmico, de tamanho no definido
  em tempo de design. O tamanho do vetor pode ser alterado
  em tempo de execuo.  utilizado para armazenar todas as fatias
  do grfico de pizza e assim, configur-las individualmente.
}

begin
    //Define o ttulo do grfico.
    ZedGraphControl1.GraphPane.Title := 'Vendas em 2005';
    //No mostrar a Axis X (reta horizontal com nmeros, na parte inferior do grfico.
    ZedGraphControl1.GraphPane.XAxis.IsVisible := false;
    //No mostrar a Axis Y (reta vertical com nmeros, na parte esquerda do grfico.
    ZedGraphControl1.GraphPane.YAxis.IsVisible := false;

    {Atravs da propriedade GraphPane podemos construir a definio do grfico.
     A funo AddPieSlices  utilizada para criar um grfico de pizza adicionando-se
     todas as fatias do grfico em uma nica instruo. As cores das fatias
     so definidas pelo componente.
     O primeiro parmetro da funo deve ser um vetor de Double (Real) contendo
     os valores das fatias do grfico. O segundo parmetro deve ser um vetor de String
     contendo a descrio para cada valor que ser utilizado para construir
     as fatias do grfico.

     A funo devolve um vetor de PieItem (fatia) contendo todas as fatias
     adicionadas ao grfico. A instruo abaixo crie as fatias e armazena-as
     no vetor.}
    fatias:= ZedGraphControl1.GraphPane.AddPieSlices(
                 [1200,1800,1400,1000],
                 ['Janeiro', 'Fevereiro', 'Maro', 'Abril']);

    {Abaixo  utilizado um dos novos recursos da Delphi Language que
     o lao de repetio For In. Com ele fica mais fcil percorrer os itens
    de uma lista. A nossa lista  o vetor Fatias. Para utilizar o For In
    deve-se declarar uma varivel do tipo dos itens da lista. No caso os itens
    do nosso vetor so do tipo PieItem, assim, a varivel Fatia tambm
    deve ser do tipo PieItem.
    Desta forma, atravs da varivel Fatia podemos acessar
    cada elemento da lista, sem nos preocuparmos com um ndice.
    O For In percorrer todos os itens da lista.

    No For In abaixo, so percorridos todos as fatias do grfico.}
    for fatia in fatias do
    begin
      {coloca um deslocamente entre cada fatia do grfico para
      que as mesmas no fiquem juntas}
      fatia.Displacement:= 0.04;
      {altera o tipo do label a ser exibido para cada fatia
      para que os mesmos mostrem o Nome da fatia, o valor
      e o percentual. Para ver as opes possveis, digite
      PieLabelType. e aguarde um momento para que sejam
      mostradas as outras opes. PieLabelType  um tipo enumerado.
      No .NET Framework, para atribuir um valor a uma propriedade
      de um tipo enumerado voc deve colocar o nome do tipo, um ponto
      e o valor enumerado, como mostrado abaixo. Desta forma
      a utilizao fica mais clara pois voc sabe, vendo o codigo,
      de que tipo o valor enumerado . }
      fatia.LabelType:= PieLabelType.Name_Value_Percent;
    end;

    {Pode-se utilizar no lugar de AddPieSlices a funo AddPieSlice
    que adiciona apenas uma fatia ao grfico. Esta  uma funo polimrfica que
    tem duas verses. No exemplo abaixo (que no deve estar habilitado no cdigo
    para este formulrio, pois j foi utilizada a funo AddPieSlices) utilizei
    a verso mais completa onde o primeiro parmetro  o valor da fatia, o segundo
     a cor inicial, o terceiro  a cor final (criando um efeito gradiente),
    o quarto  o grau de rotao do gradiente, o quarto  o deslocamento
    da fatia e o ltimo  o rtulo da mesma.}
    {
      fatia:= ZedGraphControl1.GraphPane.AddPieSlice(1200,
                 Color.Red, Color.White, 90, 0.04, 'Janeiro');
      fatia.LabelType:= PieLabelType.Name_Value_Percent;
      fatia:= ZedGraphControl1.GraphPane.AddPieSlice(1800,
                 Color.Green, Color.White, 90, 0.04, 'Fevereiro');
      fatia.LabelType:= PieLabelType.Name_Value_Percent;
      fatia:= ZedGraphControl1.GraphPane.AddPieSlice(1400,
                 Color.Blue, Color.White, 90, 0.04, 'Maro');
      fatia.LabelType:= PieLabelType.Name_Value_Percent;
      fatia:= ZedGraphControl1.GraphPane.AddPieSlice(1000,
                 Color.LightGray, Color.White, 90, 0.04, 'Abril');
      fatia.LabelType:= PieLabelType.Name_Value_Percent;
    }

    {Define a cor de preenchimento da parte onde o grfico  desenhado.
    Aqui foi utilizada uma verso do construtor da classe Fill
    (utilizada para definir o preenchimento de superfcies) que possui
    trs parmetros, sendo o primeiro a cor inicial, o segundo a cor final
    (criando um efeito gradiente) e o ltimo o ngulo do gradiente.}
    ZedGraphControl1.GraphPane.AxisFill :=
        Fill.Create( Color.White, Color.LightBlue, 180 );

    {Define a cor do painel onde o grfico e todos seus elementos so
    desenhados. Aqui foi utilizada uma verso do construtor da classe Fill
    que possui apenas um parmetro que defini uma cor fixa para o preenchimento.}
    ZedGraphControl1.GraphPane.PaneFill := Fill.Create( Color.White );

    //Define que a legenda aparecer na parte superior do grfico.
    ZedGraphControl1.GraphPane.Legend.Position := LegendPos.Top;
end;

end.
